
T0 = 5  ;

epspath = feps*ones(T+1,1) ;
upath = fu*ones(T+1,1) ;

upath(T0) = (fu + 2) ;
upath(T0+1) = (fu + 2) ;

% epspath(T0) = (feps+5) ;
% epspath(T0+1) = (feps+4) ;
% epspath(T0+2) = (feps+3) ;
% epspath(T0+3) = (feps+2) ;
% epspath(T0+4) = (feps+1) ;

for t=1:T
    pi_path3x(t) = 400*(pistar+  pi_path3(t,epspath(t),upath(t)) );
    pi_pathR3x(t) = 400*(pistar+ pi_pathR3(t,epspath(t),upath(t))) ;
    pi_pathRB3x(t) = 400*(pistar+ pi_pathRB3(t,epspath(t),upath(t))) ;
    pi_pathRC3x(t) = 400*(pistar+ pi_pathRC3(t,epspath(t),upath(t))) ;
    pi_pathRD3x(t) = 400*(pistar+ pi_pathRD3(t,epspath(t),upath(t))) ;
    
    x_path3x(t) = 100*x_path3(t,epspath(t),upath(t)) ;
    x_pathR3x(t) = 100*x_pathR3(t,epspath(t),upath(t)) ;
    x_pathRB3x(t) = 100*x_pathRB3(t,epspath(t),upath(t)) ;
    x_pathRC3x(t) = 100*x_pathRC3(t,epspath(t),upath(t)) ;
    x_pathRD3x(t) = 100*x_pathRD3(t,epspath(t),upath(t)) ;
    
    i_path3x(t) = 400*(i_path3(t,epspath(t),upath(t))-ZLBI) ;
    i_pathR3x(t) = 400*(i_pathR3(t,epspath(t),upath(t))-ZLBI) ;
    i_pathRB3x(t) = 400*(i_pathRB3(t,epspath(t),upath(t))-ZLBI) ;
    i_pathRC3x(t) = 400*(i_pathRC3(t,epspath(t),upath(t))-ZLBI) ;
    i_pathRD3x(t) = 400*(i_pathRD3(t,epspath(t),upath(t))-ZLBI) ;
end


figure ;
subplot(2,2,1) ;
plot( (1:Ts),400*std_eps*grid_eps(epspath(1:Ts))','m-','LineWidth',2) ; title('Shocks')
hold on ;
plot( (1:Ts),400*std_u*grid_u(upath(1:Ts)),'c-','LineWidth',2) ; legend('Natural Rate','Cost Push') ;
ylabel('%')

subplot(2,2,2) ;
plot( (1:Ts), x_path3x(1:Ts),'r-','LineWidth',2)
hold on ;
plot( (1:Ts), x_pathRD3x(1:Ts),'g-','LineWidth',2)
plot( (1:Ts), x_pathRC3x(1:Ts),'b-','LineWidth',2)
hold  on ;
plot( (1:Ts), zeros(Ts,1),'k-','LineWidth',1)
title('Output gap ')
ylabel('%')
legend('Optimal Discretion','Naive','Taylor Rule','Location','southeast')

subplot(2,2,3) ;
plot( (1:Ts), pi_path3x(1:Ts),'r-','LineWidth',2) ; hold on ;
plot( (1:Ts), pi_pathRD3x(1:Ts),'g-','LineWidth',2) ; hold on ;
plot( (1:Ts), pi_pathRC3x(1:Ts),'b-','LineWidth',2) ; hold  on ;
plot( (1:Ts), 2*ones(Ts,1),'k-','LineWidth',1)
title('Inflation')

subplot(2,2,4) ;
plot( (1:Ts), i_path3x(1:Ts),'r-','LineWidth',2) ; hold on ;
plot( (1:Ts), i_pathRD3x(1:Ts),'g-','LineWidth',2) ; hold on ;
plot( (1:Ts), i_pathRC3x(1:Ts),'b-','LineWidth',2) ; hold  on ;
plot( (1:Ts), 400*(pistar+rho_end)*ones(Ts,1),'k-','LineWidth',1)
ylabel('%')
title('Nominal Interest Rate')

